/*
 * Decompiled with CFR 0.152.
 */
package com.dfdyz.epicacg;

import com.dfdyz.epicacg.command.ClientCommands;
import com.dfdyz.epicacg.config.ClientConfig;
import com.dfdyz.epicacg.efmextra.skills.EpicACGSkillCategories;
import com.dfdyz.epicacg.efmextra.skills.EpicACGSkillSlot;
import com.dfdyz.epicacg.event.LoadingEvents;
import com.dfdyz.epicacg.network.Netmgr;
import com.dfdyz.epicacg.registry.Entities;
import com.dfdyz.epicacg.registry.Items;
import com.dfdyz.epicacg.registry.MobEffects;
import com.dfdyz.epicacg.registry.MyAnimations;
import com.dfdyz.epicacg.registry.MyModels;
import com.dfdyz.epicacg.registry.MySkillDataKeys;
import com.dfdyz.epicacg.registry.MySkills;
import com.dfdyz.epicacg.registry.Particles;
import com.dfdyz.epicacg.registry.PostEffects;
import com.dfdyz.epicacg.registry.Sounds;
import com.dfdyz.epicacg.registry.Tab;
import com.dfdyz.epicacg.registry.WeaponTypes;
import com.mojang.logging.LogUtils;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.slf4j.Logger;

@Mod(value="epicacg")
public class EpicACG {
    public static final String MODID = "epicacg";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final String VERSION = "20.9.6.0";

    public EpicACG() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus fg_bus = MinecraftForge.EVENT_BUS;
        bus.addListener(this::setupCommon);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            bus.addListener(EventPriority.LOWEST, this::regClientReloader);
            bus.addListener(Particles::registryParticles);
            bus.addListener(PostEffects::register);
            bus.addListener(this::setupClient);
            bus.addListener(LoadingEvents::onModelRegister);
            bus.addListener(LoadingEvents::onModelBaked);
            fg_bus.addListener(ClientCommands::registerClientCommands);
        }
        bus.addListener(MyAnimations::registerAnimations);
        bus.addListener(WeaponTypes::register);
        EpicACGSkillCategories.ENUM_MANAGER.registerEnumCls(MODID, EpicACGSkillCategories.class);
        EpicACGSkillSlot.ENUM_MANAGER.registerEnumCls(MODID, EpicACGSkillSlot.class);
        WeaponTypes.EpicACGWeaponCategories.ENUM_MANAGER.registerEnumCls(MODID, WeaponTypes.EpicACGWeaponCategories.class);
        WeaponTypes.EpicACGStyles.ENUM_MANAGER.registerEnumCls(MODID, WeaponTypes.EpicACGStyles.class);
        Items.ITEMS.register(bus);
        Entities.ENTITIES.register(bus);
        Particles.PARTICLES.register(bus);
        MobEffects.EFFECTS.register(bus);
        Tab.TABS.register(bus);
        Sounds.SOUNDS.register(bus);
        MySkillDataKeys.DATA_KEYS.register(bus);
        bus.addListener(MySkills::BuildSkills);
        bus.register((Object)Netmgr.CHANNEL);
        fg_bus.register((Object)this);
    }

    private void setupCommon(FMLCommonSetupEvent event) {
        event.enqueueWork(Netmgr::register);
    }

    private void setupClient(FMLClientSetupEvent event) {
        MyAnimations.LoadCamAnims();
        MyModels.LoadOtherModel();
        event.enqueueWork(LoadingEvents::RegItemModelOverride);
        try {
            ClientConfig.Load(false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void regClientReloader(RegisterClientReloadListenersEvent event) {
    }
}

